document.addEventListener("DOMContentLoaded", function () {
    //Variables generales
    const d = document;
    const termsButton = d.getElementById('terms-button');
    const termsCheckbox = d.getElementById('terms-checkbox');
    const privacyCheckbox = d.getElementById('privacy-checkbox');
    const textTerms = d.getElementById('text-terms');
    const termsScreen = d.getElementById('terms-screen');
    const firstScreen = d.getElementById('first-screen');
    const secondScreen = d.getElementById('second-screen');
    const thirdScreen = d.getElementById('third-screen');
    const videoPlayer = d.getElementById('video-player');
    const firstCountdown = d.getElementById('first-countdown');
    const secondCountdown = d.getElementById('second-countdown');
    const thirdCountdown = d.getElementById('third-countdown');

    //Función que maneja la aceptación de términos y condiciones
    const handleTermsConditions = () => {
        termsButton.addEventListener('click', ()=>{
            if(!termsCheckbox.checked || !privacyCheckbox.checked) {
                textTerms.classList.add('error-alert');
                textTerms.textContent = '¡ Es necesario que aceptes los términos y condiciones para que puedas navegar !';
            }
            else {
                console.log('Comienza a navegar !!');
                termsScreen.classList.remove('display-active');
                termsScreen.classList.add('display-inactive');
                handleScreens();
            }
        })
    }; 

    //Función que maneja las pantallas
    const handleScreens = () => {
        firstScreen.classList.remove('display-inactive');
        firstScreen.classList.add('display-active');
        resetCountDown();
        handleCountDown(firstCountdown);
        setTimeout(() => {
            resetCountDown();
            firstScreen.classList.remove('display-active');
            firstScreen.classList.add('display-inactive');
            secondScreen.classList.remove('display-inactive');
            secondScreen.classList.add('display-active');
            videoPlayer.setAttribute('autoplay', '');
            videoPlayer.play();
            handleCountDown(secondCountdown);
            setTimeout(() => {
                videoPlayer.removeAttribute('autoplay');
                videoPlayer.pause();
                secondScreen.classList.remove('display-active');
                secondScreen.classList.add('display-inactive');
                resetCountDown();
                thirdScreen.classList.remove('display-inactive');
                thirdScreen.classList.add('display-active');
                handleCountDown(thirdCountdown);
                setTimeout(() => {
                    resetCountDown();
                }, 5000);
            }, 5000);
        }, 3000);
    };

    //Función que maneja el countdown
    let counterInterval = null;
    const handleCountDown = (countdown) => {
        let counter = parseInt(countdown.textContent);
        if(counterInterval) {
            clearInterval(counterInterval);
        }
        counterInterval = setInterval(() => {
           counter --;
           countdown.textContent = counter; 
           if(counter === 0) {
                resetCountDown();
           }
        }, 1000);
    };

    const resetCountDown = () => {
        if(counterInterval) {
            clearInterval(counterInterval);
            counterInterval = null;
        }
    };

    handleTermsConditions();
});
